#include "CE2_TST_Common.h"

void PrintTestBeginMsg(FILE* out, const DxUint8_t* testName)
{
  fprintf(stdout, "\n%s: Begin \n", testName);
  if (out != stdout)
    fprintf(out, "\n%s: Begin \n", testName);
}

void PrintTestEndMsg(FILE* out, const DxUint8_t* testName, DxStatus testResult)
{
  if (testResult == CE2_TST_VALID) {
    fprintf(stdout, "%s: ..... PASS\n", testName);
    if (out != stdout)
      fprintf(out, "%s: ..... PASS\n", testName);
  } else {
	  fprintf(stdout, "%s: ### FAILED ###\n", testName);
    if (out != stdout)
			fprintf(out, "%s: ### FAILED ###\n", testName);
  }
}

void PrintBuffer(FILE* out, DxUint8_t* buffer, DxUint32_t size, DxUint8_t* comment)
{
  DxUint32_t i;

  if (comment) 
    fprintf(out, "%s", comment);
  for(i = 0; i < size; i++) {
    if (i%16 == 0)
      fprintf(out, "\n");
    fprintf(out, " ");
    if (buffer[i] < 0x10)
      fprintf(out, "0");
    fprintf(out, "%X", buffer[i]);
  }
  fprintf(out, "\n");
}

